/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Vector;

public final class VWRuleSetDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7448L;
    protected String m_Name = null;
    protected boolean m_Expensive = false;
    private VWWorkflowDefinition myWorkflow;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:22:10 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/4 $";
    }

    protected VWRuleSetDefinition(VWWorkflowDefinition theWorkflow, String theName) throws VWException {
        this.myWorkflow = theWorkflow;
        this.setName(theName);
    }

    public String getValue() {
        return this.getName();
    }

    public String getName() {
        return this.translateStr(this.m_Name);
    }

    public void setValue(String theValue) throws VWException {
        this.setName(theValue);
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWRuleSetDefinitionNullOrEmptyName", "The name of a rule set cannot be null or empty.");
        }
        if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWRuleSetInvalidRuleSetName", "The name, \"{0}\", is invalid, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name beginning with F_, or be a language keyword such as ''if'', or a function name such as ''userid'' or ''addminutes'').", theName, 128);
        }
        if (this.myWorkflow != null && this.myWorkflow.isExistingRuleSet(theName)) {
            throw new VWException("vw.api.VWRuleSetDefinitionNameAlreadyExists", "The name is invalid, (a RuleSet with name {0} already exists in this workflow definition).", theName);
        }
        this.m_Name = theName;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, "\t");
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(baseIndent);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRuleSetDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append(baseIndent + "<RuleSet Val=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"");
        if (this.m_Expensive) {
            theBuffer.append("\n" + indentB + "Expensive=\"" + this.m_Expensive + "\"");
        }
        theBuffer.append("/>\n");
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        if (EDefVector == null) {
            EDefVector = new Vector<VWValidationError>();
        }
        if (this.myWorkflow == null) {
            throw new VWException("vw.api.VWRuleSetDefinitionNullWorkflowRef", "No reference to containing workflow definition, runtime milestone definition, cannot validate.");
        }
        if (this.m_Name == null || this.m_Name.length() == 0) {
            theMessage = new VWString("vw.api.VWRuleSetDefinitionValidationNullOrEmptyName", "Ruleset name for a rule set cannot be null or empty.");
            theError = new VWValidationError(9, 1, null, null, theMessage.toString(), null);
            EDefVector.addElement(theError);
        }
        if (!VWFieldType.isValidName(this.m_Name)) {
            theMessage = new VWString("vw.api.VWRuleSetValidationInvalidRuleSetName", "Ruleset name, \"{0}\", is invalid, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name beginning with F_, or be a language keyword such as ''if'', or a function name such as ''userid'' or ''addminutes'').", this.m_Name, 128);
            theError = new VWValidationError(9, 1, this.m_Name, null, theMessage.toString(), null);
            EDefVector.addElement(theError);
        }
        if (this.getWorkflowDefinition().isExistingRuleSet(this.m_Name)) {
            theMessage = new VWString("vw.api.VWRuleSetDefinitionNameAlreadyExists", "Ruleset name is invalid, (a RuleSet with name {0} already exists in this workflow definition).", this.m_Name);
            theError = new VWValidationError(9, 1, this.m_Name, null, theMessage.toString(), null);
            EDefVector.addElement(theError);
        }
    }

    public void setExpensive(boolean expensive) throws VWException {
        this.m_Expensive = expensive;
    }

    public boolean getExpensive() throws VWException {
        return this.m_Expensive;
    }

    protected VWWorkflowDefinition getWorkflowDefinition() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    public String toString() {
        if (this.m_Name != null) {
            return this.m_Name;
        }
        return "";
    }

    public Object clone() {
        try {
            VWRuleSetDefinition rx = (VWRuleSetDefinition)super.clone();
            return rx;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected VWSession getSession() throws VWException {
        if (this.myWorkflow != null) {
            return this.myWorkflow.getSession();
        }
        return null;
    }
}

